/* <nagf07.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f07 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2154 (Feb 1998).
 * Mark 6 revised. IER-3037 (July 2000).
 */
#ifndef NAGF07
#define NAGF07

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  //Cheney change Complex to complex 2006-6-6
extern NAG_DLL_EXPIMP void NAG_CALL f07adc(Nag_OrderType order, Integer m, Integer n, double a[], 
		Integer pda, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07aec(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer nrhs, const double a[], Integer pda, const Integer ipiv[], double b[], Integer pdb,
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07agc(Nag_OrderType order, Nag_NormType norm, Integer n, 
			const double a[], Integer pda, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ahc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, const Integer ipiv[], 
			const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ajc(Nag_OrderType order, Integer n, double a[], Integer pda, 
			const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07arc(Nag_OrderType order, Integer m, Integer n, complex a[], 
			Integer pda, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07asc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07auc(Nag_OrderType order, Nag_NormType norm, Integer n, 
			const complex a[], Integer pda, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07avc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], 
			const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07awc(Nag_OrderType order, Integer n, complex a[], Integer pda, 
			const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bdc(Nag_OrderType order, Integer m, Integer n, Integer kl, 
			Integer ku, double ab[], Integer pdab, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bec(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer kl, Integer ku, Integer nrhs, const double ab[], Integer pdab, const Integer ipiv[],
			double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bgc(Nag_OrderType order, Nag_NormType norm, Integer n, 
			Integer kl, Integer ku, const double ab[], Integer pdab, const Integer ipiv[], double anorm,
			double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bhc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer kl, Integer ku, Integer nrhs, const double ab[], Integer pdab, const double afb[], 
			Integer pdafb, const Integer ipiv[], const double b[], Integer pdb, double x[], Integer pdx, 
			double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07brc(Nag_OrderType order, Integer m, Integer n, Integer kl, 
			Integer ku, complex ab[], Integer pdab, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bsc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer kl, Integer ku, Integer nrhs, const complex ab[], Integer pdab, const Integer ipiv[], 
			complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07buc(Nag_OrderType order, Nag_NormType norm, Integer n, 
			Integer kl, Integer ku, const complex ab[], Integer pdab, const Integer ipiv[], double anorm, 
			double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07bvc(Nag_OrderType order, Nag_TransType trans, Integer n, 
			Integer kl, Integer ku, Integer nrhs, const complex ab[], Integer pdab, const complex afb[], 
			Integer pdafb, const Integer ipiv[], const complex b[], Integer pdb, complex x[], Integer pdx, 
			double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fdc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fec(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double a[], Integer pda, double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fgc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const double a[], Integer pda, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fhc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, 
			const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fjc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07frc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fsc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fuc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex a[], Integer pda, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, 
			const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07fwc(Nag_OrderType order, Nag_UploType uplo, Integer n,
			 complex a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gdc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gec(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double ap[], double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ggc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const double ap[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ghc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double ap[], const double afp[], const double b[], Integer pdb, 
			double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gjc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07grc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gsc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07guc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex ap[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], const complex afp[], const complex b[], Integer pdb, 
			complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07gwc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hdc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, double ab[], Integer pdab, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hec(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, Integer nrhs, const double ab[], Integer pdab, double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hgc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, const double ab[], Integer pdab, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hhc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, Integer nrhs, const double ab[], Integer pdab, const double afb[], Integer pdafb, 
			const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hrc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, complex ab[], Integer pdab, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hsc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, Integer nrhs, const complex ab[], Integer pdab, complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07huc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, const complex ab[], Integer pdab, double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07hvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer kd, Integer nrhs, const complex ab[], Integer pdab, const complex afb[], Integer pdafb, 
			const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mdc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double a[], Integer pda, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mec(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double a[], Integer pda, const Integer ipiv[], double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mgc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const double a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mhc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double a[], Integer pda, const double af[], Integer pdaf, const Integer ipiv[], 
			const double b[], Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mjc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double a[], Integer pda, const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mrc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex a[], Integer pda, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07msc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07muc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], 
			const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07mwc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex a[], Integer pda, const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07nrc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex a[], Integer pda, Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07nsc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07nuc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex a[], Integer pda, const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07nvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex a[], Integer pda, const complex af[], Integer pdaf, const Integer ipiv[], 
			const complex b[], Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07nwc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex a[], Integer pda, const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pdc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double ap[], Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pec(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double ap[], const Integer ipiv[], double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pgc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const double ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07phc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const double ap[], const double afp[], const Integer ipiv[], const double b[], 
			Integer pdb, double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pjc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			double ap[], const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07prc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07psc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07puc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], const complex afp[], const Integer ipiv[], const complex b[], 
			Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07pwc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07qrc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07qsc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], const Integer ipiv[], complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07quc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			const complex ap[], const Integer ipiv[], double anorm, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07qvc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			Integer nrhs, const complex ap[], const complex afp[], const Integer ipiv[], const complex b[], 
			Integer pdb, complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07qwc(Nag_OrderType order, Nag_UploType uplo, Integer n, 
			complex ap[], const Integer ipiv[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tec(Nag_OrderType order, Nag_UploType uplo, 
			Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double a[], Integer pda, 
			double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tgc(Nag_OrderType order, Nag_NormType norm, 
			Nag_UploType uplo, Nag_DiagType diag, Integer n, const double a[], Integer pda, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07thc(Nag_OrderType order, Nag_UploType uplo, 
			Nag_TransType trans, Nag_DiagType diag, Integer n, Integer nrhs, const double a[], 
			Integer pda, const double b[], Integer pdb, const double x[], Integer pdx, double ferr[], 
			double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tjc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
			Integer n, double a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tsc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const complex a[], Integer pda, complex b[], 
			Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, 
			Nag_DiagType diag, Integer n, const complex a[], Integer pda, double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07tvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const complex a[], Integer pda, const complex b[], 
			Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07twc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
			Integer n, complex a[], Integer pda, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07uec(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const double ap[], double b[], Integer pdb, 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ugc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, 
			Nag_DiagType diag, Integer n, const double ap[], double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07uhc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const double ap[], const double b[], Integer pdb, 
			const double x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07ujc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
			Integer n, double ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07usc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const complex ap[], complex b[], Integer pdb, 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07uuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, 
			Nag_DiagType diag, Integer n, const complex ap[], double *rcond, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07uvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer nrhs, const complex ap[], const complex b[], 
			Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07uwc(Nag_OrderType order, Nag_UploType uplo, Nag_DiagType diag, 
			Integer n, complex ap[], NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vec(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, 
			double b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vgc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, 
			Nag_DiagType diag, Integer n, Integer kd, const double ab[], Integer pdab, double *rcond, 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vhc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const double ab[], Integer pdab, 
			const double b[], Integer pdb, const double x[], Integer pdx, double ferr[], double berr[], 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vsc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, 
			complex b[], Integer pdb, NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vuc(Nag_OrderType order, Nag_NormType norm, Nag_UploType uplo, 
			Nag_DiagType diag, Integer n, Integer kd, const complex ab[], Integer pdab, double *rcond, 
			NagError *fail);
extern NAG_DLL_EXPIMP void NAG_CALL f07vvc(Nag_OrderType order, Nag_UploType uplo, Nag_TransType trans, 
			Nag_DiagType diag, Integer n, Integer kd, Integer nrhs, const complex ab[], Integer pdab, 
			const complex b[], Integer pdb, const complex x[], Integer pdx, double ferr[], double berr[],
			NagError *fail);
  extern void f07ad0(Integer m, Integer n, double *a, Integer lda, double piv[], 
                     Integer *info);
  extern void f07ad1(Integer m, Integer n, double *a, Integer lda, 
                     double piv[], Integer *info);
  extern void f07ad2(Integer n, double *a, Integer lda, Integer k1, Integer k2, 
                     double piv[], Integer incx);
  extern void f07adg_f(Integer m, Integer n, double a[], Integer lda,
                       double piv[], Integer *info);
  extern void f07adg(Integer m, Integer n, double *a, Integer tda, double *piv,
                     Integer *info);
  extern void f07adh_f(Integer m, Integer n, double a[], Integer lda,
                       double piv[], Integer *info);
  extern void f07adh(Integer m, Integer n, double *a, Integer tda, double *piv,
                     Integer *info);
  extern void f07adj_f(Integer n, double a[], Integer lda, Integer k1,
                       Integer k2, const double piv[], Integer incx);
  extern void f07adj(Integer n, double *a, Integer tda, Integer k1, Integer k2,
                     double *piv, Integer incx);
  extern void f07ae0(const char *trans, Integer n, Integer nrhs, double *a, Integer lda,
                     double piv[], double *b, Integer ldb, Integer *info);
  extern void f07aeg(MatrixTranspose trans, Integer n, Integer nrhs, double *a,
                     Integer tda, double *piv, double *b, Integer tdb, Integer *info);
  extern NAG_DLL_EXPIMP void NAG_CALL f07fdc_0(MatrixTriangle uplo, Integer n, double a[], Integer tda,
                                               Integer *info);
  extern void f07fdf_f(const char *uplo, Integer n, double a[], Integer lda,
                       Integer *info, Integer uplo_len);
  extern void f07fdz_f(const char *uplo, Integer n, double a[], Integer lda,
                       Integer *info, Integer uplo_len);
  extern void f07fdz(MatrixTriangle uplo, Integer n, double a[], Integer tda,
                     Integer *info);
  extern void f07fjf_f(const char *uplo, Integer n, double a[], Integer lda,
                       Integer *info, Integer uplo_len);
  extern void f07fjy_f(const char *uplo, Integer n, double a[], Integer lda,
                       Integer *info, Integer uplo_len);
  extern void f07fjz_f(const char *uplo, Integer n, double a[], Integer lda,
                       Integer *info, Integer uplo_len);
  extern void f07fry(Integer n, complex *x, Integer incx);
  extern void f07gdf_f(const char *uplo, Integer n, double ap[], Integer *info,
                       Integer uplo_len);
  extern void f07gef_f(const char *uplo, Integer n, Integer nrhs, const double ap[],
                       double b[], Integer ldb, Integer *info, Integer uplo_len);
  extern void f07gjf_f(const char *uplo, Integer n, double ap[], Integer *info,
                       Integer uplo_len);
  extern void f07mdx_f(double a, double b, double c, double *rt1,
                       double *rt2, double *cs1, double *sn1);
  extern void f07mdx(double a, double b, double c, double *rt1,
                     double *rt2, double *cs1, double *sn1);
  extern void f07tgz(const char *uplo, const char *trans, const char *diag, const char *normin, Integer n,
                     double a[], Integer lda, double x[],
                     double *scale, double cnorm[], Integer *info);
  extern void f07tjf_f(const char *uplo, const char *diag, Integer n, double a[],
                       Integer lda, Integer *info, Integer uplo_len, Integer diag_len);
  extern void f07tjz_f(const char *uplo, const char *diag, Integer n, double a[],
                       Integer lda, Integer *info, Integer uplo_len, Integer diag_len);
  extern void f07tuz(const char *uplo, const char *trans, const char *diag, const char *normin, Integer n,
                     complex a[], Integer lda, complex x[],
                     double *scale, double cnorm[], Integer *info);
  extern void f07uef_f(const char *uplo, const char *trans, const char *diag, Integer n,
                       Integer nrhs, const double ap[], double b[], Integer ldb,
                       Integer *info, Integer uplo_len, Integer trans_len, Integer diag_len);
  extern void f07ujf_f(const char *uplo, const char *diag, Integer n, double ap[],
                       Integer *info, Integer uplo_len, Integer diag_len);
  extern Integer f07za0(const char *name);
  extern void f07za1(Integer ispec, const char *name, Integer *ival, Integer rwflag);
  extern Integer f07zay_f(const char *name, Integer name_len);
  extern Integer f07zay(const char *name);
  extern void f07zaz_f(Integer ispec, const char *name, Integer *ival, Integer rwflag,
                       Integer name_len);
  extern void f07zaz(Integer ispec, const char *name, Integer *ival, Integer rwflag);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF07 */
